#version 150

#moj_import <fog.glsl>

uniform sampler2D Sampler0;

uniform vec4 ColorModulator;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;

in float vertexDistance;
in vec4 vertexColor;
in vec2 texCoord0;
in vec4 normal;

out vec4 fragColor;

void main() {
    vec4 tex = texture(Sampler0, texCoord0);
    vec4 color;
    vec4 glow;

    if (tex.a == (253.0 / 255.0)){
        tex.a = 1.0;

        // The expected color
        color = tex * ColorModulator * vertexColor;

        // Glow only color
        glow = tex * ColorModulator * vec4(3.5);

        color = (color * vec4(0.75)) + (glow * vec4(0.21));

        color.a = 1.0;

        fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);
    } else {
        color = texture(Sampler0, texCoord0) * vertexColor * ColorModulator;
        fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);
    }
}
